<?php

use Drupal\node\Entity\Node;
use Drupal\media\Entity\Media;
use Drupal\file\Entity\File;
use Drupal\Core\File\FileSystemInterface;

/**
 * Migrate public audio to private audio.
 */

$fs = \Drupal::service('file_system');

$nids = \Drupal::entityQuery('node')
  ->condition('type', 'project')
  ->exists('field_audio')
  ->execute();

foreach (Node::loadMultiple($nids) as $node) {
  if (!$node->hasField('field_audio') || $node->get('field_audio')->isEmpty()) {
    continue;
  }

  $old_media = $node->get('field_audio')->entity;
  if (!$old_media || !$old_media->hasField('field_media_audio')) {
    continue;
  }

  $old_file = $old_media->get('field_media_audio')->entity;
  if (!$old_file instanceof File) {
    continue;
  }

  $source_uri = $old_file->getFileUri();
  $filename = $old_file->getFilename();
  $private_uri = "private://audio/{$filename}";

  $fs->prepareDirectory('private://audio', FileSystemInterface::CREATE_DIRECTORY);

  if (!$fs->copy($source_uri, $private_uri, FileSystemInterface::EXISTS_RENAME)) {
    echo "❌ Failed to copy {$filename} to private directory.\n";
    continue;
  }

  $new_file = File::create([
    'uri' => $private_uri,
    'status' => FILE_STATUS_PERMANENT,
    'uid' => $node->getOwnerId(),
  ]);
  $new_file->save();

  $new_media = Media::create([
    'bundle' => 'private_audio',
    'name' => $old_media->label(),
    'field_audio_private' => [
      'target_id' => $new_file->id(),
    ],
    'uid' => $node->getOwnerId(),
    'status' => 1,
  ]);
  $new_media->save();

  $node->set('field_audio_private', [
    'target_id' => $new_media->id(),
  ]);
  $node->save();

  echo "✅ Node {$node->id()} updated with private audio.\n";
}

