<?php

namespace Drupal\iframe\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Link;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;

/**
 * The Class IframeAsurlFormatter.
 */
#[FieldFormatter(
  id: 'iframe_asurl',
  label: new TranslatableMarkup('A link with the given title'),
  field_types: [
    'iframe',
  ],
)]
class IframeAsurlFormatter extends IframeDefaultFormatter {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    foreach ($items as $delta => $item) {
      if (empty($item->url)) {
        continue;
      }
      if (!(property_exists($item, 'title') && $item->title !== NULL)) {
        $item->title = '';
      }
      $linktext = empty($item->title) ? $item->url : $item->title;
      $elements[$delta] = [
        '#markup' => Link::fromTextAndUrl($linktext, Url::fromUri($item->url, ['title' => $item->title]))->toString(),
        '#allowed_tags' => ['iframe', 'a', 'h1', 'h2', 'h3', 'h4'],
      ];
    }
    return $elements;
  }

}
