# MediaElementJS

Provides HTML5 video and audio elements using Mediaelement.js
for HTML4 browsers.

## Installation

1. Download MediaElement from [http://mediaelementjs.com/](http://mediaelementjs.com/)
2. Unzip into a libraries directory as supported by the libraries module with
   the name mediaelement (e.g., /sites/all/libraries/mediaelement).
3. Install the libraries and mediaelement modules.

## Usage

Set a file field or link field to use video (or audio) as its display formatter.
Or use the [Media module](http://drupal.org/project/media) if you want to have your
file field display images and video.

## API

This module supplies the MediaElement library as a Drupal library and has some
helper functions if you want to use it independently of fields. To add the
library into a page use the command:

```
drupal_add_library('mediaelement', 'mediaelement');
```

If you want to use the helper scripts include the script
mediaelement.js included with the module. You can do it
using a command like:

```
drupal_add_js(drupal_get_path('module', 'mediaelement') . '/mediaelement.js');
```

Then you need to add settings for the script. They are a selector for jQuery and
settings. For example:

```
$settings = array('mediaelement' => array(
  '.class-name' => array(
    'controls' => TRUE,
    'opts' => array(), // This is the mediaelement scripts options.
  )
));
drupal_add_js($settings, 'setting');
```

For more details on the MediaElement API see [http://mediaelementjs.com](http://mediaelementjs.com)
